﻿<%@ Page language="c#" codePage="1200" %>

<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>

<%@ Import Namespace="System.ComponentModel" %>
<%@ Import Namespace="Soneta.Waluty" %>
<%@ Import Namespace="Soneta.CRM" %>
<%@ Import Namespace="Soneta.Kasa" %>
<%@ Import Namespace="Soneta.Ksiega" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Types" %>
<%@ Import Namespace="Soneta.Tools" %>
<%@ Import Namespace="Soneta.Kasa.Forms" %>
<%@ Import Namespace="Soneta.Ksiega.Forms" %>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<title>Analiza płatności - zestawienie</title>
		<script runat="server">
	
            //Raport wg wpisanej nazwy cechy. 
            //UWAGA! Działa tylko jeżeli raport dla kontrahentów
            //Poniżej należy uzupełnić wszystkie 3 wartości, są to:
            //1. Nazwa cechy kontrahenta        
            const string wgWartościCechy = "";
            //2. Nazwa słownika 
            const string wgWartościDictionary = "";
            //3. Etykieta wyświetlana podczas pytania o wartość pola
            const string wgWartościLabel = "";		    
		    
	public enum Zakres {
		Razem, Kontrahenci, Pracownicy, Urzędy
	}
	
	class Podsumowanie {
		readonly IPodmiotKasowy podmiot;
		readonly bool należności;
		
		decimal razem;
		decimal niezapłacone;
		decimal częściowo;
		decimal terminowe;
		decimal d7;
		decimal d14;
		decimal d30;
		decimal p30;
		
		public Podsumowanie(IPodmiotKasowy podmiot, bool należności) {
		    this.podmiot = podmiot;
			this.należności = należności;
		}
		
		public void Add(RozrachunekIdx idx,StanRozliczeniaRozrachunkuWorker worker)
		{
		    Date data = idx.DataRozliczenia;
		    Date termin = idx.Termin;

			worker.RozrachunekIdx = idx;
			decimal kwota = worker.Kwota.Value;
			
			razem += kwota;
			if (data==Date.MaxValue) {
				decimal d = worker.KwotaRozliczona.Value;
				niezapłacone += kwota - d;
				częściowo += d;
			}
			else if (termin==Date.Empty || data<=termin)
				terminowe += kwota;
			else {
				int d = data - termin;
				if (d<=7)
					d7 += kwota;
				else if (d<=14)
					d14 += kwota;
				else if (d<=30)
					d30 += kwota;
				else
					p30 += kwota;					
			}
		}
		
		public IPodmiotKasowy Podmiot {
			get { return podmiot; }
		}		
		public decimal Razem {
			get { return razem; }
		}
		public decimal Niezapłacone {
			get { return niezapłacone; }
		}
		public decimal Częściowo {
			get { return częściowo; }
		}
		public decimal Terminowe {
			get { return terminowe; }
		}
		public decimal D7 {
			get { return d7; }
		}
		public decimal D14 {
			get { return d14; }
		}
		public decimal D30 {
			get { return d30; }
		}
		public decimal P30 {
			get { return p30; }
		}		
	}
	
	public enum TypDokumentów {
		Zobowiązania, Należności
	}
	
	public class PrnParams: Soneta.Business.OkresContext {
		public PrnParams(Context context): base(context) {
			waluta = WalutyModule.GetInstance(this).Waluty.PLN;
			if (Context.Contains(typeof(OkresContext)))
				base.Okres = ((OkresContext)Context[typeof(OkresContext)]).Okres;
		}
		
		[Priority(0)]
		[Browsable(false)]
		public override Date Aktualny {
			get { return base.Aktualny; }
			set { base.Aktualny = value; }
		}
		
		[Priority(1)]
		public override FromTo Okres {
			get { return base.Okres; }
			set
			{
				base.Okres = value.IsNull ? FromTo.All : value; 

			}
		}
		
		Zakres zakres = Zakres.Kontrahenci;
		[Priority(2)]
		public Zakres Zakres {
			get { return zakres; }
			set { 
				zakres = value; 
				OnChanged(EventArgs.Empty);
			}
		}

		public RowCondition Condition() {
			switch (zakres) {
				case Zakres.Kontrahenci:
					return new FieldCondition.TypeOf("Podmiot", typeof(Soneta.CRM.Kontrahent));
				case Zakres.Pracownicy:
					return new FieldCondition.TypeOf("Podmiot", typeof(Soneta.Kadry.Pracownik));
				case Zakres.Urzędy:
					RowCondition condition = RowCondition.Empty;
					condition = new FieldCondition.TypeOf("Podmiot", typeof(Soneta.CRM.Kontrahent));
					condition |= new FieldCondition.TypeOf("Podmiot", typeof(Soneta.Kadry.Pracownik));
					return new RowCondition.Not(condition);
				default:
					return RowCondition.Empty;
			}
		}
		
		IPodmiotKasowy odk;
		[Caption("Od kontrahenta")]
		[Priority(3)]
		public IPodmiotKasowy Od {
			get { return odk; }
			set { 
				odk = value; 
				OnChanged(EventArgs.Empty);
			}
		}
		
		IPodmiotKasowy dok;
		[Priority(4)]
		[Caption("Do kontrahenta")]
		public IPodmiotKasowy Do {
			get { return dok; }
			set { 
				dok = value; 
				OnChanged(EventArgs.Empty);
			}
		}

        string wartośćCechy = "";
        [Priority(5)]
        [Caption(wgWartościLabel)]
        [Browsable(wgWartościLabel != "")]
        [Dictionary(wgWartościDictionary)]
        public string WartośćCechy {
            get { return wartośćCechy; }
            set {
                wartośćCechy = value;
                OnChanged(EventArgs.Empty);
            }
        }

        public bool IsReadOnlyWartośćCechy() {
            return wgWartościCechy == "" || zakres != Zakres.Kontrahenci;
        }
        
        
		TypDokumentów dokumenty = TypDokumentów.Należności;
		[Priority(6)]
		public TypDokumentów Dokumenty {
			get { return dokumenty; }
			set { 
				dokumenty = value; 
				OnChanged(EventArgs.Empty);
			}
		}
		
        RodzajDokumentów rodzaj = RodzajDokumentów.Płatności;
		[Priority(7)]
        [Caption("Rodzaj")]
        public RodzajDokumentów Rodzaj {
            get { return rodzaj; }
            set { 
                rodzaj = value;
                OnChanged(EventArgs.Empty);
            }
        }		
		
		Waluta waluta;
		[Priority(8)]
		[Required]
		public Waluta Waluta {
			get { return waluta; }
			set { 
				waluta = value; 
				OnChanged(EventArgs.Empty);
			}
		}


		string aktualneKonto = "";
		[Priority(11)]
		public string AktualneKonto
		{
			get { return aktualneKonto; }
			set
			{
				aktualneKonto = value.ToUpper();
				OnChanged(EventArgs.Empty);
			}
		}	
	}

	private PrnParams pars = null;
	private WydrukiRozrachunkowFiltr wr = new WydrukiRozrachunkowFiltr();
	
	[Soneta.Business.Context(Required = true)] 
	public PrnParams Params { 
		get { return pars; } 
		set { pars = value; } 
	} 

    
    [Context(Required = true)]
	public WydrukOddzialParams OParams { get; set; }


    class ComparePodmiot: IComparer {
		public int Compare(object x, object y) {
			IPodmiotKasowy px = (IPodmiotKasowy)x;
			IPodmiotKasowy py = (IPodmiotKasowy)y;
			return px.Kod.CompareTo(py.Kod);
		}
    }

	
	void OnContextLoad(object sender, EventArgs e)
	{	    
		bool należności = pars.Dokumenty==TypDokumentów.Należności;

		wr.PodmiotOd = pars.Od;
		wr.PodmiotDo = pars.Do;
		wr.Waluta = pars.Waluta;
		wr.SetAktualneKonto(pars.AktualneKonto, pars.Aktualny);
		wr.SetFeature(wgWartościCechy, pars.WartośćCechy);
				
		KasaModule kasa = KasaModule.GetInstance(pars);
		RozrachunkiIdx rozrachunki = kasa.RozrachunkiIdx;
		Soneta.Business.View view = rozrachunki.Wszystkie(null, pars.Okres);
		view.Condition &= pars.Condition();
	    view.Condition &= OParams.GetConditionIdx();
		
        RowCondition condition = kasa.RozrachunkiIdx.ZakresEx(
            należności && pars.Rodzaj!=RodzajDokumentów.Zapłaty,
            !należności && pars.Rodzaj!=RodzajDokumentów.Zapłaty,
            !należności && pars.Rodzaj!=RodzajDokumentów.Płatności,
            należności && pars.Rodzaj!=RodzajDokumentów.Płatności);
        if (condition!=RowCondition.Empty)
            view.Condition &= condition;
		
        ReportHeader1["ODDZIAL"] = OParams.GetTitleItem();
		ReportHeader1["TYP"] = należności ? "należności" : "zobowiązań";
		ReportHeader1["KONTRAHENT"] = wr.GetTitleStringPodmiot();
		ReportHeader1["KONTO"] = wr.GetTitleStringKonto();
		ReportHeader1["WALUTA"] = wr.GetTitleStringWaluta(false);

		if (pars.Zakres == Zakres.Razem)
			ReportHeader1["ZAKRES"] = "";
		else
			ReportHeader1["ZAKRES"] = "|</strong>Zakres: <strong>" + pars.Zakres;

		if (pars.Rodzaj == RodzajDokumentów.Razem)
			ReportHeader1["RODZAJ"] = "";
		else
			ReportHeader1["RODZAJ"] = "|</strong>Rodzaj: <strong>" + pars.Rodzaj;

        if (pars.Zakres != Zakres.Kontrahenci || pars.WartośćCechy == "")
            ReportHeader1["WGCECHY"] = "";
        else
            ReportHeader1["WGCECHY"] = string.Format("|</strong>{0}: <strong> {1}", wgWartościCechy, pars.WartośćCechy);

		StanRozliczeniaRozrachunkuWorker worker = new StanRozliczeniaRozrachunkuWorker();
		worker.StanRozliczenia = StanRozliczeniaRozrachunku.Nierozliczone;

		wr.SetFilter(view);
		Podsumowanie pds = new Podsumowanie(null, należności);
		
		foreach (RozrachunekIdx idx in view)
			pds.Add(idx, worker);

		Grid1.DataSource = new object[] { pds };
	}
		    
	
		</script>
	
	</HEAD>
	<body>
		<form id="StrukturaWiekowaNaleznosciKontrahenci" method="post" runat="server">
			<ea:datacontext id="dc" runat="server" oncontextload="OnContextLoad"></ea:datacontext>
			<cc1:reportheader id="ReportHeader1" title="Analiza %TYP% - zestawienie|%ODDZIAL%</strong>Za okres: <strong>{0}%RODZAJ%%ZAKRES%%WGCECHY%%KONTRAHENT%%WALUTA%%KONTO%"
				runat="server" ContextTypeName="Soneta.Business.OkresContext,Soneta.Business" DataMember0="Okres"></cc1:reportheader><ea:grid id="Grid1" runat="server" RowsInRow="1">
				<Columns>
					<ea:GridColumn Width="4" Align="Right" DataMember="#" Caption="Lp."></ea:GridColumn>
					<ea:GridColumn Align="Right" DataMember="Razem" Total="Sum" Caption="Razem" HideZero="True" Format="{0:n}"></ea:GridColumn>
					<ea:GridColumn Align="Right" DataMember="Niezapłacone" Total="Sum" Caption="Niezapłacone" HideZero="True"
						Format="{0:n}"></ea:GridColumn>
					<ea:GridColumn Align="Right" DataMember="Częściowo" Total="Sum" Caption="Częściowo" HideZero="True"
						Format="{0:n}"></ea:GridColumn>
					<ea:GridColumn Align="Right" DataMember="Terminowe" Total="Sum" Caption="Dokonane wpłaty~terminowe"
						HideZero="True" Format="{0:n}"></ea:GridColumn>
					<ea:GridColumn Align="Right" DataMember="D7" Total="Sum" Caption="Dokonane wpłaty~od 1 do 7" HideZero="True"
						Format="{0:n}"></ea:GridColumn>
					<ea:GridColumn Align="Right" DataMember="D14" Total="Sum" Caption="Dokonane wpłaty~od 8 do 14"
						HideZero="True" Format="{0:n}"></ea:GridColumn>
					<ea:GridColumn Align="Right" DataMember="D30" Total="Sum" Caption="Dokonane wpłaty~od 15 do 30"
						HideZero="True" Format="{0:n}"></ea:GridColumn>
					<ea:GridColumn Align="Right" DataMember="P30" Total="Sum" Caption="Dokonane wpłaty~ponad 30" HideZero="True"
						Format="{0:n}"></ea:GridColumn>
				</Columns>
			</ea:grid><cc1:reportfooter id="ReportFooter1" runat="server">
				<Subtitles>
					<cc1:FooterSubtitle SubtitleType="Operator"></cc1:FooterSubtitle>
					<cc1:FooterSubtitle Caption="Sporządził" SubtitleType="Podpis"></cc1:FooterSubtitle>
					<cc1:FooterSubtitle Caption="Sprawdził" SubtitleType="Podpis"></cc1:FooterSubtitle>
					<cc1:FooterSubtitle Caption="Zatwierdził" SubtitleType="Podpis"></cc1:FooterSubtitle>
				</Subtitles>
			</cc1:reportfooter>
		</form>
	</body>
</HTML>
